<?php

namespace Database\Factories;

use App\Enums\FlatStatus;
use App\Models\Flat;
use App\Models\Owner;
use App\Models\Wing;
use Illuminate\Database\Eloquent\Factories\Factory;

class FlatFactory extends Factory
{
    protected $model = Flat::class;

    public function definition(): array
    {
        return [
            'wing_id' => Wing::factory(),
            'owner_id' => Owner::factory(),
            'flat_no' => $this->faker->randomElement(['A', 'B', 'C', 'D']) . $this->faker->numberBetween(101, 999),
            'status' => $this->faker->randomElement(FlatStatus::cases()),
            'flat_sqrft' => $this->faker->numberBetween(500, 3000),
        ];
    }

    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => FlatStatus::ACTIVE,
        ]);
    }

    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => FlatStatus::IN_ACTIVE,
        ]);
    }
}