<?php

namespace App\Http\Resources;

use App\Models\DailyPatrolSummary;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin DailyPatrolSummary */
class DailyPatrolSummaryResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'patrol_date' => $this->patrol_date,
            'total_locations' => $this->total_locations,
            'completed_locations' => $this->completed_locations,
            'missed_locations' => $this->missed_locations,
            'completion_percentage' => $this->completion_percentage,

            // Time fields
            'expected_start_time' => $this->expected_start_time?->format('H:i'),
            'expected_end_time' => $this->expected_end_time?->format('H:i'),
            'actual_start_time' => $this->actual_start_time?->format('Y-m-d H:i:s'),
            'actual_end_time' => $this->actual_end_time?->format('Y-m-d H:i:s'),
            'expected_duration' => $this->expected_duration,
            'actual_duration' => $this->actual_duration,
            'is_on_time' => $this->is_on_time,
            'is_delayed' => $this->is_delayed,

            'status' => $this->status,
            'notes' => $this->notes,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'guard_id' => $this->guard_id,
            'patrol_round_id' => $this->patrol_round_id,

            'guard' => new UserResource($this->whenLoaded('guardUser')),
            'patrol_round' => new PatrolRoundResource($this->whenLoaded('patrolRound')),
            'patrolling_logs' => PatrollingLogResource::collection($this->whenLoaded('patrollingLogs')),
        ];
    }
}
