<?php

namespace App\Http\Resources;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin User */
class UserResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'role' => $this->role,
            'gender' => $this->gender,
            'relation' => $this->relation,
            'email_verified_at' => $this->email_verified_at,
            'photo' => $this->photo,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'owner_id' => $this->owner_id,
            'flat_id' => $this->flat_id,

            'owner' => new OwnerResource($this->whenLoaded('owner')),
            'flat' => new FlatResource($this->whenLoaded('flat')),
        ];
    }
}
