<?php

namespace App\Http\Requests\Owner;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreOwnerRequest extends FormRequest
{
    public function rules(): array {
        return [
            'name' => ['required', 'string'],
            'email' => [
                'required', 'email', 'max:254',
                Rule::unique('owners', 'email')
            ],
            'phone' => ['required'],
            'aadhaar_no' => [
                'required', 'string', 'max:254',
                Rule::unique('owners', 'aadhaar_no')
            ],
            'pan_no' => [
                'required', 'string', 'max:254',
                Rule::unique('owners', 'pan_no')
            ],

            'aadhaar_card' => ['nullable', 'file', 'max:5120'],
            'pan_card' => ['nullable', 'file', 'max:5120'],
            'photo' => ['nullable', 'file', 'max:5120'],
        ];
    }

    public function authorize() {
        return true;
    }
}
