<?php

use App\Enums\VehicleLogType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicle_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->nullable()->constrained('vehicles')->onDelete('cascade');
            $table->foreignId('guard_id')->constrained('users')->onDelete('cascade');
            $table->enum('log_type', VehicleLogType::values());
            $table->timestamp('logged_at');
            $table->string('purpose')->nullable();
            $table->json('visitor_details')->nullable();
            $table->json('outsider_vehicle_details')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicle_logs');
    }
};
