<?php

namespace Database\Factories;

use App\Models\Owner;
use Illuminate\Database\Eloquent\Factories\Factory;

class OwnerFactory extends Factory
{
    protected $model = Owner::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone' => $this->faker->unique()->numerify('##########'),
            'aadhaar_no' => $this->faker->unique()->numerify('############'),
            'pan_no' => $this->faker->unique()->regexify('[A-Z]{5}[0-9]{4}[A-Z]{1}'),
        ];
    }
}