<?php

namespace App\Http\Resources;

use App\Models\VehicleLog;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin VehicleLog */
class VehicleLogResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'log_type' => $this->log_type,
            'logged_at' => $this->logged_at,
            'purpose' => $this->purpose,
            'visitor_details' => $this->visitor_details,
            'outsider_vehicle_details' => $this->outsider_vehicle_details,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'vehicle_id' => $this->vehicle_id,
            'guard_id' => $this->guard_id,

            'vehicle' => new VehicleResource($this->whenLoaded('vehicle')),
            'guard' => new UserResource($this->whenLoaded('guardUser')),
        ];
    }
}
