<?php

namespace App\Enums;

enum VisitorStatus: string
{
    case PENDING = "pending";
    case APPROVED = "approved";
    case REJECTED = "rejected";
    case CHECKED_IN = "checked_in";
    case CHECKED_OUT = "checked_out";
    case EXPIRED = "expired";

    /**
     * Get all visitor status values
     */
    public static function values(): array {
        return array_column(self::cases(), 'value');
    }
}