<?php

namespace Database\Factories;

use App\Models\Wing;
use Illuminate\Database\Eloquent\Factories\Factory;

class WingFactory extends Factory
{
    protected $model = Wing::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->randomElement(['A Wing', 'B Wing', 'C Wing', 'D Wing', 'E Wing', 'F Wing', 'Tower 1', 'Tower 2', 'Block A', 'Block B']),
            'no_floors' => $this->faker->numberBetween(5, 25),
            'no_flats' => $this->faker->numberBetween(20, 100),
            'no_lifts' => $this->faker->numberBetween(1, 4),
            'fire_extinguisher_date' => $this->faker->dateTimeBetween('-1 year', '+1 year'),
        ];
    }
}