<?php

namespace App\Http\Requests\Flat;

use App\Enums\FlatStatus;
use App\Http\Requests\BaseRequest;
use Illuminate\Validation\Rule;

class UpdateFlatRequest extends BaseRequest
{
    public function rules() {
        return [
            'wing_id' => ['sometimes', 'exists:wings,id'],
            'owner_id' => ['sometimes', 'exists:owners,id'],
            'flat_no' => ['sometimes', 'string'],
            'status' => ['sometimes', Rule::enum(FlatStatus::class)],
            'flat_sqrft' => ['sometimes', 'numeric'],

            'agreement' => $this->validateFile('agreement'),
            'other_docs' => $this->validateFile('other_docs'),
        ];
    }

    public function authorize() {
        return true;
    }
}
